/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.linker;

import filenet.vw.apps.linker.images.VWImageLoader;
import filenet.vw.apps.linker.resources.VWResource;
import filenet.vw.base.VWDebug;
import filenet.vw.idm.toolkit.IVWIDMPropertyDescription;
import filenet.vw.idm.toolkit.expr.VWIDMExprParser;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class VWLinkerLaunchPropertyDialog
extends VWModalDialog
implements ActionListener {
    protected static final int MAX_EXPRESSION_LENGTH = 254;
    private static final String s_andStr = " and ";
    private static final String s_orStr = " or ";
    protected JLabel m_launchType = null;
    protected JComboBox m_propertyComboBox = null;
    protected JLabel m_propertyType = null;
    protected JComboBox m_operatorComboBox = null;
    protected JComboBox m_valueComboBox = null;
    protected JTextField m_valueTextField = null;
    protected boolean m_bHasPreDefinedValue = false;
    protected JButton m_OKButton = null;
    protected JButton m_cancelButton = null;
    protected JButton m_helpButton = null;
    protected JButton m_andButton = null;
    protected JButton m_orButton = null;
    protected JButton m_rightParenButton = null;
    protected JButton m_leftParenButton = null;
    protected JButton m_insertButton = null;
    protected JButton m_clearButton = null;
    protected JTextArea m_conditionArea = null;
    protected int m_retStatus = 1;
    protected Frame m_parentFrame = null;
    protected IVWIDMPropertyDescription[] m_propertyList = null;
    protected IVWIDMPropertyDescription m_selectedProp = null;
    protected DateFormat[] s_dateTimeFormatters = new DateFormat[]{DateFormat.getDateTimeInstance(2, 3), DateFormat.getDateTimeInstance(2, 2), DateFormat.getDateTimeInstance(3, 3), DateFormat.getDateTimeInstance(3, 2), DateFormat.getDateTimeInstance(1, 3), DateFormat.getDateTimeInstance(1, 2), DateFormat.getDateTimeInstance(1, 1), DateFormat.getDateTimeInstance(3, 1), DateFormat.getDateTimeInstance(0, 0)};

    public VWLinkerLaunchPropertyDialog(Frame parent, IVWIDMPropertyDescription[] propertyList, String launchType) {
        super(parent);
        try {
            this.m_parentFrame = parent;
            if (propertyList != null && propertyList.length > 0) {
                this.m_propertyList = new IVWIDMPropertyDescription[propertyList.length];
                System.arraycopy(propertyList, 0, this.m_propertyList, 0, propertyList.length);
            }
            this.m_launchType = new JLabel(launchType);
            this.setTitle(VWResource.LaunchCondition);
            Dimension dim = VWStringUtils.stringToDimension(VWResource.LaunchPropertyDialogDim);
            if (dim == null) {
                dim = new Dimension(400, 350);
            }
            this.setSize(dim);
            this.setVisible(false);
            this.getContentPane().setLayout(new BorderLayout(10, 10));
            this.getContentPane().add((Component)this.createTopPanel(), "First");
            this.getContentPane().add((Component)this.createMiddlePanel(), "Center");
            this.getContentPane().add((Component)this.createButtonPanel(), "Last");
            this.m_propertyComboBox.setSelectedIndex(0);
            this.setLocationRelativeTo(parent);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected JPanel createTopPanel() {
        JPanel topPanel = null;
        try {
            topPanel = new JPanel();
            topPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbConst = new GridBagConstraints();
            gbConst.fill = 2;
            gbConst.anchor = 23;
            gbConst.gridwidth = 1;
            gbConst.gridheight = 1;
            gbConst.weightx = 0.0;
            gbConst.insets = new Insets(4, 10, 4, 10);
            gbConst.gridx = 0;
            gbConst.gridy = 0;
            gbConst.weightx = 0.0;
            JLabel launchLabel = new JLabel(VWResource.s_label.toString(VWResource.LaunchType), 2);
            topPanel.add((Component)launchLabel, gbConst);
            gbConst.gridx = 1;
            gbConst.weightx = 1.0;
            topPanel.add((Component)this.m_launchType, gbConst);
            gbConst.gridx = 0;
            gbConst.gridy = 1;
            gbConst.weightx = 0.0;
            JLabel propertyLabel = new JLabel(VWResource.s_label.toString(VWResource.Property), 2);
            topPanel.add((Component)propertyLabel, gbConst);
            this.m_propertyComboBox = new JComboBox();
            for (int i = 0; i < this.m_propertyList.length; ++i) {
                this.m_propertyComboBox.addItem(this.m_propertyList[i]);
            }
            this.m_propertyComboBox.setRenderer(new PropertyComboBoxRender());
            gbConst.gridx = 1;
            gbConst.weightx = 1.0;
            topPanel.add((Component)this.m_propertyComboBox, gbConst);
            this.m_propertyComboBox.addActionListener(this);
            gbConst.gridx = 0;
            gbConst.gridy = 2;
            gbConst.weightx = 0.0;
            JLabel propertyTypeLabel = new JLabel(VWResource.s_label.toString(VWResource.PropertyType), 2);
            topPanel.add((Component)propertyTypeLabel, gbConst);
            gbConst.gridx = 1;
            gbConst.weightx = 1.0;
            this.m_propertyType = new JLabel();
            topPanel.add((Component)this.m_propertyType, gbConst);
            gbConst.gridx = 0;
            gbConst.gridy = 3;
            gbConst.weightx = 0.0;
            JLabel operatorLabel = new JLabel(VWResource.s_label.toString(VWResource.Operator), 2);
            topPanel.add((Component)operatorLabel, gbConst);
            gbConst.fill = 0;
            gbConst.gridx = 1;
            this.m_operatorComboBox = new JComboBox();
            topPanel.add((Component)this.m_operatorComboBox, gbConst);
            this.m_operatorComboBox.addActionListener(this);
            gbConst.fill = 2;
            gbConst.gridx = 0;
            gbConst.gridy = 4;
            gbConst.weightx = 0.0;
            JLabel valueLabel = new JLabel(VWResource.s_label.toString(VWResource.Value), 2);
            topPanel.add((Component)valueLabel, gbConst);
            gbConst.gridx = 1;
            gbConst.gridwidth = 2;
            gbConst.weightx = 1.0;
            this.m_valueComboBox = new JComboBox();
            this.m_valueComboBox.setVisible(false);
            topPanel.add((Component)this.m_valueComboBox, gbConst);
            this.m_valueComboBox.addActionListener(this);
            this.m_valueTextField = new JTextField();
            topPanel.add((Component)this.m_valueTextField, gbConst);
            this.m_valueTextField.addActionListener(this);
            this.m_bHasPreDefinedValue = false;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return topPanel;
    }

    private JPanel createOperationButtons() {
        JPanel panel = null;
        GridBagConstraints gbCons = null;
        try {
            panel = new JPanel(new GridBagLayout());
            gbCons = new GridBagConstraints();
            gbCons.anchor = 23;
            gbCons.fill = 0;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(2, 2, 2, 2);
            this.m_andButton = VWImageLoader.createIconButton("and.gif", s_andStr.trim());
            this.m_andButton.setEnabled(true);
            panel.add((Component)this.m_andButton, gbCons);
            ++gbCons.gridx;
            this.m_orButton = VWImageLoader.createIconButton("or.gif", s_orStr.trim());
            this.m_orButton.setEnabled(true);
            panel.add((Component)this.m_orButton, gbCons);
            gbCons.fill = 2;
            ++gbCons.gridx;
            gbCons.weightx = 0.05;
            gbCons.insets = new Insets(2, 0, 2, 0);
            panel.add((Component)new JPanel(), gbCons);
            gbCons.fill = 0;
            ++gbCons.gridx;
            gbCons.weightx = 0.0;
            gbCons.insets = new Insets(2, 2, 2, 2);
            this.m_leftParenButton = VWImageLoader.createIconButton("lparen.gif", VWResource.AddLeftParen);
            this.m_leftParenButton.setEnabled(true);
            panel.add((Component)this.m_leftParenButton, gbCons);
            ++gbCons.gridx;
            this.m_rightParenButton = VWImageLoader.createIconButton("rparen.gif", VWResource.AddRightParen);
            this.m_rightParenButton.setEnabled(true);
            panel.add((Component)this.m_rightParenButton, gbCons);
            gbCons.fill = 2;
            ++gbCons.gridx;
            gbCons.weightx = 0.05;
            gbCons.insets = new Insets(2, 0, 2, 0);
            panel.add((Component)new JPanel(), gbCons);
            gbCons.fill = 0;
            ++gbCons.gridx;
            gbCons.weightx = 0.0;
            gbCons.insets = new Insets(2, 2, 2, 2);
            this.m_insertButton = new JButton(VWResource.s_insert);
            this.m_insertButton.setToolTipText(VWResource.InsertExpression);
            panel.add((Component)this.m_insertButton, gbCons);
            gbCons.fill = 2;
            ++gbCons.gridx;
            gbCons.weightx = 0.9;
            gbCons.insets = new Insets(2, 0, 2, 0);
            panel.add((Component)new JPanel(), gbCons);
            gbCons.fill = 0;
            ++gbCons.gridx;
            gbCons.weightx = 0.0;
            gbCons.insets = new Insets(2, 2, 2, 2);
            this.m_clearButton = VWImageLoader.createIconButton("delete.gif", VWResource.Clear);
            this.m_clearButton.setEnabled(true);
            panel.add((Component)this.m_clearButton, gbCons);
            Insets margin = this.m_insertButton.getMargin();
            margin.left = margin.top;
            margin.right = margin.bottom;
            this.m_andButton.setMargin(margin);
            this.m_orButton.setMargin(margin);
            this.m_leftParenButton.setMargin(margin);
            this.m_rightParenButton.setMargin(margin);
            this.m_clearButton.setMargin(margin);
            this.m_andButton.addActionListener(this);
            this.m_orButton.addActionListener(this);
            this.m_rightParenButton.addActionListener(this);
            this.m_leftParenButton.addActionListener(this);
            this.m_insertButton.addActionListener(this);
            this.m_clearButton.addActionListener(this);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return panel;
    }

    private JPanel createMiddlePanel() {
        JPanel panel = null;
        GridBagConstraints gbCons = null;
        try {
            panel = new JPanel();
            panel.setLayout(new GridBagLayout());
            gbCons = new GridBagConstraints();
            gbCons.anchor = 23;
            gbCons.fill = 2;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(4, 1, 4, 1);
            panel.add((Component)this.createOperationButtons(), gbCons);
            gbCons.fill = 1;
            ++gbCons.gridy;
            gbCons.weightx = 1.0;
            gbCons.weighty = 1.0;
            this.m_conditionArea = new JTextArea();
            this.m_conditionArea.setLineWrap(true);
            this.m_conditionArea.setWrapStyleWord(true);
            panel.add((Component)new JScrollPane(this.m_conditionArea), gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return panel;
    }

    private JPanel createButtonPanel() {
        JPanel mainPanel = null;
        GridBagConstraints gbConst = new GridBagConstraints();
        try {
            mainPanel = new JPanel();
            mainPanel.setLayout(new GridBagLayout());
            gbConst.fill = 2;
            gbConst.gridwidth = 2;
            gbConst.gridheight = 1;
            gbConst.insets = new Insets(10, 10, 10, 10);
            this.m_OKButton = new JButton(VWResource.OK);
            mainPanel.add((Component)this.m_OKButton, gbConst);
            this.m_cancelButton = new JButton(VWResource.Cancel);
            mainPanel.add((Component)this.m_cancelButton, gbConst);
            this.m_helpButton = new JButton(VWResource.Help);
            mainPanel.add((Component)this.m_helpButton, gbConst);
            this.m_OKButton.addActionListener(this);
            this.m_cancelButton.addActionListener(this);
            this.m_helpButton.addActionListener(this);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return mainPanel;
    }

    public void actionPerformed(ActionEvent event) {
        Object obj = event.getSource();
        if (obj == this.m_propertyComboBox) {
            this.performPropertySelection();
        } else if (obj == this.m_OKButton) {
            this.performOKButton();
        } else if (obj == this.m_cancelButton) {
            this.m_retStatus = 1;
            this.setVisible(false);
        } else if (obj == this.m_helpButton) {
            VWHelp.displayPage(VWHelp.Help_eProcess_Doc + "link/vwlinkerlaunchpropertydialog.htm");
        } else if (obj == this.m_andButton) {
            this.m_conditionArea.insert(s_andStr, this.m_conditionArea.getCaretPosition());
        } else if (obj == this.m_orButton) {
            this.m_conditionArea.insert(s_orStr, this.m_conditionArea.getCaretPosition());
        } else if (obj == this.m_rightParenButton) {
            this.m_conditionArea.insert(")", this.m_conditionArea.getCaretPosition());
        } else if (obj == this.m_leftParenButton) {
            this.m_conditionArea.insert("(", this.m_conditionArea.getCaretPosition());
        } else if (obj == this.m_insertButton) {
            String expr = this.getExpression();
            if (expr != null) {
                if (this.m_conditionArea.getText().length() + expr.length() > 254) {
                    JOptionPane.showMessageDialog(this, VWResource.LaunchConditionIsTooLong, null, 0, null);
                } else {
                    this.m_conditionArea.insert(expr, this.m_conditionArea.getCaretPosition());
                }
            }
        } else if (obj == this.m_clearButton) {
            this.m_conditionArea.setText("");
        }
    }

    private void performOperatorSelection(IVWIDMPropertyDescription propertyDesc) {
        try {
            this.m_valueTextField.setText("");
            this.m_operatorComboBox.removeAllItems();
            if (propertyDesc == null) {
                this.m_insertButton.setEnabled(false);
            } else {
                if (propertyDesc.canSearchWithEqualOperator()) {
                    this.m_operatorComboBox.addItem(VWResource.IsEqual);
                }
                if (propertyDesc.canSearchWithNotEqualOperator()) {
                    this.m_operatorComboBox.addItem(VWResource.NotEqual);
                }
                if (propertyDesc.canSearchWithGreaterOperator()) {
                    this.m_operatorComboBox.addItem(VWResource.IsGreaterThan);
                }
                if (propertyDesc.canSearchWithGreaterOrEqualOperator()) {
                    this.m_operatorComboBox.addItem(VWResource.IsGreaterThanOrEqual);
                }
                if (propertyDesc.canSearchWithLessOperator()) {
                    this.m_operatorComboBox.addItem(VWResource.IsLessThan);
                }
                if (propertyDesc.canSearchWithLessOrEqualOperator()) {
                    this.m_operatorComboBox.addItem(VWResource.IsLessThanOrEqual);
                }
                if (propertyDesc.canSearchWithLikeOperator()) {
                    this.m_operatorComboBox.addItem(VWResource.Contains);
                }
                if (propertyDesc.canSearchWithNotLikeOperator()) {
                    this.m_operatorComboBox.addItem(VWResource.NotContain);
                }
                if (this.m_operatorComboBox.getItemCount() > 0) {
                    this.m_insertButton.setEnabled(true);
                } else {
                    this.m_insertButton.setEnabled(false);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void displayValueComboBox(IVWIDMPropertyDescription propertyDesc) {
        if (propertyDesc == null) {
            return;
        }
        try {
            if (!this.m_bHasPreDefinedValue) {
                this.m_valueComboBox.setVisible(true);
                this.m_valueTextField.setVisible(false);
                this.m_bHasPreDefinedValue = true;
            }
            this.m_valueComboBox.removeAllItems();
            Object[] valueList = propertyDesc.getChoices();
            for (int i = 0; i < valueList.length; ++i) {
                this.m_valueComboBox.addItem(valueList[i]);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private String displayPropertyType() {
        String typeStr = "";
        int typeID = this.m_selectedProp.getTypeID();
        switch (typeID) {
            case 11: {
                typeStr = VWResource.TypeBoolean;
                break;
            }
            case 7: {
                typeStr = VWResource.TypeDate;
                break;
            }
            case 5: {
                typeStr = VWResource.TypeFloat;
                break;
            }
            case 3: {
                typeStr = VWResource.TypeInteger;
                break;
            }
            case 8: {
                typeStr = VWResource.TypeString;
            }
        }
        return typeStr;
    }

    private void displayValueTextField() {
        try {
            if (this.m_bHasPreDefinedValue) {
                this.m_valueComboBox.setVisible(false);
                this.m_valueTextField.setVisible(true);
                this.m_bHasPreDefinedValue = false;
            } else if (this.m_selectedProp.getTypeID() == 7) {
                DateFormat df = DateFormat.getDateTimeInstance(2, 3);
                Date dt = new Date();
                this.m_valueTextField.setText(df.format(dt));
            } else {
                this.m_valueTextField.setText("");
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performPropertySelection() {
        try {
            this.m_selectedProp = (IVWIDMPropertyDescription)this.m_propertyComboBox.getSelectedItem();
            this.m_propertyType.setText(this.displayPropertyType());
            this.performOperatorSelection(this.m_selectedProp);
            this.m_valueComboBox.setEnabled(true);
            if (this.m_selectedProp.hasChoices()) {
                this.displayValueComboBox(this.m_selectedProp);
            } else {
                this.displayValueTextField();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private boolean validateLaunchCondition() {
        boolean bRet = false;
        try {
            String launchCondition = this.m_conditionArea.getText();
            String[] msg = VWIDMExprParser.validate(launchCondition, this.m_propertyList);
            if (msg != null) {
                VWMessageDialog.showOptionDialog(this.m_parentFrame, msg, 1);
            } else {
                bRet = true;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return bRet;
    }

    private void performOKButton() {
        try {
            if (this.validateLaunchCondition()) {
                this.m_retStatus = 0;
                this.setVisible(false);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public int getReturnStatus() {
        return this.m_retStatus;
    }

    public String getLaunchCondition() {
        String launchCondition = null;
        try {
            launchCondition = this.m_conditionArea.getText();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return launchCondition;
    }

    public void setLaunchCondition(String launchCondition) {
        if (launchCondition != null) {
            this.m_conditionArea.setText(launchCondition);
        }
    }

    private String standardlizeOperator(String selOp) {
        String opStr = null;
        if (VWStringUtils.compare(selOp, VWResource.IsEqual) == 0) {
            opStr = "=";
        } else if (VWStringUtils.compare(selOp, VWResource.NotEqual) == 0) {
            opStr = "<>";
        } else if (VWStringUtils.compare(selOp, VWResource.IsGreaterThan) == 0) {
            opStr = ">";
        } else if (VWStringUtils.compare(selOp, VWResource.IsGreaterThanOrEqual) == 0) {
            opStr = ">=";
        } else if (VWStringUtils.compare(selOp, VWResource.IsLessThan) == 0) {
            opStr = "<";
        } else if (VWStringUtils.compare(selOp, VWResource.IsLessThanOrEqual) == 0) {
            opStr = "<=";
        } else if (VWStringUtils.compare(selOp, VWResource.Contains) == 0) {
            opStr = "contains";
        } else if (VWStringUtils.compare(selOp, VWResource.NotContain) == 0) {
            opStr = "notcontain";
        }
        return opStr;
    }

    private String toGMTPattern(Date dt) {
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.applyPattern("MM/dd/yyyy HH:mm:ss zzz");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        return sdf.format(dt);
    }

    private String getExpression() {
        String expression = null;
        String msg = null;
        boolean bSuccess = true;
        try {
            Comparable<Calendar> dt;
            String value = null;
            IVWIDMPropertyDescription property = (IVWIDMPropertyDescription)this.m_propertyComboBox.getSelectedItem();
            if (this.m_bHasPreDefinedValue) {
                if (property.getTypeID() == 7) {
                    dt = (GregorianCalendar)this.m_valueComboBox.getSelectedItem();
                    value = "'" + this.toGMTPattern(dt.getTime()) + "'";
                } else {
                    value = this.m_valueComboBox.getSelectedItem().toString();
                }
            } else {
                value = this.m_valueTextField.getText().trim();
                block2 : switch (property.getTypeID()) {
                    case 7: {
                        dt = null;
                        int count = this.s_dateTimeFormatters.length;
                        for (int i = 0; i < count; ++i) {
                            try {
                                dt = this.s_dateTimeFormatters[i].parse(value);
                                if (dt == null) continue;
                                value = "'" + this.toGMTPattern((Date)dt) + "'";
                                break block2;
                            }
                            catch (ParseException ex) {
                                if (i != count - 1) continue;
                                bSuccess = false;
                                DateFormat df = DateFormat.getDateTimeInstance(2, 3);
                                msg = VWResource.UseDateFormat.toString(df.format(new Date()));
                                JOptionPane.showMessageDialog(this, VWResource.InValidInputValue.toString(msg), null, 0, null);
                            }
                        }
                        break;
                    }
                    case 5: {
                        msg = VWResource.UseFloatTypeInput;
                        Double.valueOf(value);
                        break;
                    }
                    case 3: {
                        msg = VWResource.UseIntegerTypeInput;
                        Integer.valueOf(value);
                        break;
                    }
                    case 8: {
                        int len = value.length();
                        if (len <= 1 || (value.charAt(0) != '\"' || value.charAt(len - 1) != '\"') && (value.charAt(0) != '\'' || value.charAt(len - 1) != '\'')) break;
                        value = value.substring(1, len - 1);
                        break;
                    }
                }
            }
            if (bSuccess) {
                String operatorStr = (String)this.m_operatorComboBox.getSelectedItem();
                expression = property.getTypeID() == 8 ? property.getName() + " " + this.standardlizeOperator(operatorStr) + " '" + value + "'" : property.getName() + " " + this.standardlizeOperator(operatorStr) + " " + value;
            }
        }
        catch (NumberFormatException nEx) {
            JOptionPane.showMessageDialog(this, VWResource.InValidInputValue.toString(msg), null, 0, null);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return expression;
    }

    private static class PropertyComboBoxRender
    extends DefaultListCellRenderer {
        private PropertyComboBoxRender() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, hasFocus);
            if (value != null && value instanceof IVWIDMPropertyDescription) {
                IVWIDMPropertyDescription property = (IVWIDMPropertyDescription)value;
                this.setText(property.getLabel() + " (" + property.getName() + ")");
            }
            return this;
        }
    }
}

